<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Halaman utama diarahkan ke dashboard (dengan filter login)
$routes->get('/', 'Dashboard::index', ['filter' => 'auth']);

// 🔐 Routes untuk login dan logout
$routes->get('/login', 'Auth::login');
$routes->post('/auth/login', 'Auth::loginProcess');
$routes->get('/logout', 'Auth::logout');

// 🔒 Group semua route yang butuh login (autentikasi)
$routes->group('', ['filter' => 'auth'], function($routes) {
    // Dashboard Umum (bisa redirect ke role dashboard)
    $routes->get('/dashboard', 'Dashboard::index');

    // Dashboard Khusus Per Role
    $routes->get('/dashboard/guru', 'Dashboard::guru', ['filter' => 'auth']);
    $routes->get('/dashboard/kepsek', 'Dashboard::kepsek', ['filter' => 'auth']);
    $routes->get('/dashboard/admin', 'Dashboard::admin', ['filter' => 'auth']);

    // 📋 CRUD Data Guru
    $routes->get('/guru/input', 'GuruController::index');
    $routes->post('/guru/save', 'GuruController::save');
    $routes->get('guru/cetak_pdf', 'GuruController::cetakPdf');


    // 📊 Evaluasi Guru
    $routes->get('/evaluasi', 'EvaluasiController::index');         // Halaman utama evaluasi
    $routes->get('/evaluasi/create', 'EvaluasiController::create'); // Form input evaluasi
    $routes->post('/evaluasi/store', 'EvaluasiController::store');  // Menyimpan evaluasi
    $routes->get('/evaluasi/edit/(:num)', 'EvaluasiController::edit/$1');
    $routes->post('/evaluasi/update/(:num)', 'EvaluasiController::update/$1');
    $routes->get('/evaluasi/delete/(:num)', 'EvaluasiController::delete/$1'); // Hapus evaluasi
    $routes->post('/evaluasi/approve/(:num)', 'EvaluasiController::approve/$1'); // Approve
    $routes->post('/evaluasi/reject/(:num)', 'EvaluasiController::reject/$1');   // Reject
    $routes->post('evaluasi/simpanNilai', 'EvaluasiController::simpanNilai');
    $routes->get('evaluasi/cetak/(:num)', 'EvaluasiController::cetakPdf/$1');
    



  // halaman penilaian kinerja guru
    $routes->get('evaluasi/nilai/(:num)', 'EvaluasiController::formNilai/$1');
    $routes->post('evaluasi/simpanNilai/(:num)', 'EvaluasiController::simpanNilai/$1');
    
    // **Tambahan route untuk evaluasi_kinerja**
    $routes->get('/evaluasi/evaluasi_kinerja', 'EvaluasiController::evaluasi_kinerja');

    // ✅ Tampilan Evaluasi Berdasarkan Role
    $routes->get('/evaluasi/evaluasi_admin', 'EvaluasiController::evaluasi_admin');
    $routes->get('/evaluasi/evaluasi_kepsek', 'EvaluasiController::evaluasi_kepsek');
    $routes->get('/evaluasi/evaluasi_guru', 'EvaluasiController::evaluasi_guru');

    // 🔧 Halaman Profil dan Evaluasi Guru
    $routes->get('/guru/profil', 'GuruController::profil');
    $routes->get('/guru/evaluasi', 'GuruController::evaluasi');
    $routes->get('rpp/upload', 'RppController::formUpload');
    $routes->post('rpp/upload', 'RppController::saveUpload');

    // 📊 Rekapitulasi Kinerja Guru
    $routes->get('/rekap', 'RekapPeform::index');

    // 📚 Manajemen Periode
    $routes->get('/periode', 'PeriodeController::index');
    $routes->get('/periode/create', 'PeriodeController::create');
    $routes->get('periode/delete/(:num)', 'PeriodeController::delete/$1');
    $routes->post('/periode/store', 'PeriodeController::store');

      // 👤 Profil Pengguna (semua role)
    $routes->get('/profile', 'Profile::index');
    $routes->get('profile/create', 'Profile::create');
    $routes->post('/profile/store', 'Profile::store');
    $routes->post('/profile/update', 'Profile::update');

    // 👤 Manajemen Akun User (Admin)
    $routes->get('/users', 'UserController::index');
    $routes->get('/users/create', 'UserController::create');
    $routes->post('/users/store', 'UserController::store');
    $routes->get('/users/edit/(:num)', 'UserController::edit/$1');
    $routes->post('/users/update/(:num)', 'UserController::update/$1');
    $routes->get('/users/delete/(:num)', 'UserController::delete/$1');

    // manajemen kelas
    $routes->get('kelas', 'Kelas::index');
    $routes->get('kelas/create', 'Kelas::create');
    $routes->post('kelas/store', 'Kelas::store');
    $routes->get('kelas/edit/(:num)', 'Kelas::edit/$1');
    $routes->post('kelas/update/(:num)', 'Kelas::update/$1');
    $routes->get('kelas/delete/(:num)', 'Kelas::delete/$1');

});

// Optional: Group tambahan untuk guru (CRUD lengkap)
$routes->group('guru', function ($routes) {
    $routes->get('/', 'GuruController::index');
    $routes->get('create', 'GuruController::create');
    $routes->post('store', 'GuruController::store');
    $routes->get('edit/(:num)', 'GuruController::edit/$1');
    $routes->post('update/(:num)', 'GuruController::update/$1');
    $routes->get('delete/(:num)', 'GuruController::delete/$1');
});
