<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\GuruModel;
use App\Models\EvaluasiModel;
use App\Models\Periode;

class Dashboard extends BaseController
{
    public function index()
{
     
    // Redirect otomatis berdasarkan role
    $role = session()->get('login')['role'] ?? null;

    switch ($role) {
        case 'admin':
            return redirect()->to('/dashboard/admin');
        case 'kepsek':
            return redirect()->to('/dashboard/kepsek');
        case 'guru':
            return redirect()->to('/dashboard/guru');
        default:
            return redirect()->to('/login');
    }
}

public function admin()
{
    $guruModel = new \App\Models\GuruModel();
    $userModel = new \App\Models\M_user(); // Tambahkan model user
    $evaluasiModel = new \App\Models\EvaluasiModel();

    $totalGuru = $guruModel->getTotalGuru();
    $totalUser = $userModel->countAll(); // Menghitung semua user di tabel 'users'
    $totalLaporan = $evaluasiModel->countAll(); // Tambahan
    $data = [
        'totalGuru' => $totalGuru,
        'totalUser' => $totalUser,
        'totalLaporan' => $totalLaporan,
    ];

    $periodeModel = new Periode();
    $dataperiode = $periodeModel->findAll();
    $guruList = $guruModel->findAll();
    $evaluasiModel = new EvaluasiModel();
    
    $rekap = [];

    foreach ($dataperiode as $periode) {
        $periodeRekap = [
        'periode' => $periode,
        'guru' => []
        ];

        foreach ($guruList as $guru) {
        // Cari evaluasi untuk guru dan periode ini
        $evaluasi = $evaluasiModel
            ->where('periode', $periode['id'])
            ->where('id_guru', $guru['id'])
            ->first();

        $totalNilai = 0;

        if ($evaluasi) {
            $totalNilai = $evaluasi['nilai'] ?? 0;
        }

        $periodeRekap['guru'][] = [
            'id_guru' => $guru['id'],
            'nama_guru' => $guru['nama_guru'],
            'total_nilai' => $totalNilai
        ];
        }

        $rekap[] = $periodeRekap;
    }

    $data['totalLaporan'] = $totalLaporan;      // Tambahan
    $data['rekap'] = $rekap;


    return view('dashboard/admin', $data);
}


public function kepsek()
{
    $guruModel     = new GuruModel();
    $evaluasiModel = new EvaluasiModel();
    $periodeModel  = new Periode();

    // Ambil data guru dan periode
    $guruList      = $guruModel->findAll();
    $dataperiode   = $periodeModel->orderBy('tanggal_mulai', 'ASC')->findAll(); // Urutkan periode

    // Hitung statistik umum
    $totalGuru       = $guruModel->getTotalGuru();
    $totalDisetujui  = $evaluasiModel->where('status', 'Disetujui')->countAllResults();
    $totalDitolak    = $evaluasiModel->where('status', 'Ditolak')->countAllResults();
    $ajuan           = $evaluasiModel->where('status', 'Diajukan')->countAllResults();

    // Buat array rekap nilai per periode
    $rekap = [];

    foreach ($dataperiode as $periode) {
        $periodeRekap = [
            'periode' => $periode,
            'guru' => []
        ];

        foreach ($guruList as $guru) {
            // Ambil data evaluasi berdasarkan guru dan periode
            $evaluasi = $evaluasiModel
                ->where('periode', $periode['id'])
                ->where('id_guru', $guru['id'])
                ->first();

            // Ambil nilai total dari kolom 'nilai' jika ada
            $totalNilai = 0;
            if ($evaluasi && isset($evaluasi['nilai'])) {
                $totalNilai = (int)$evaluasi['nilai'];
            }

            // Simpan ke array
            $periodeRekap['guru'][] = [
                'id_guru'    => $guru['id'],
                'nama_guru'  => $guru['nama_guru'],
                'total_nilai' => $totalNilai
            ];
        }

        $rekap[] = $periodeRekap;
    }

    // Kirim data ke view
    $data = [
        'totalGuru'      => $totalGuru,
        'totalDisetujui' => $totalDisetujui,
        'totalDitolak'   => $totalDitolak,
        'ajuan'          => $ajuan,
        'evaluasi'       => $evaluasiModel->getAllEvaluasiWithGuru(),
        'rekap'          => $rekap
    ];

    return view('dashboard/kepsek', $data);
}


public function guru()
{
    $login = session()->get('login');
    $idUser = $login['id']; // ID user (dari tabel users)

    $guruModel       = new \App\Models\GuruModel();
    $evaluasiModel   = new \App\Models\EvaluasiModel();
    $userModel       = new \App\Models\M_user();
    // Ambil id_guru dari users
    $user = $userModel->find($idUser);
    $idGuru = $user['id_guru'];

    // Ambil semua evaluasi guru terkait
    $evaluasi = $evaluasiModel->where('id_guru', $idGuru)->findAll();

    // Hitung status evaluasi
    $totalDisetujui = $evaluasiModel
        ->where('id_guru', $idGuru)
        ->where('status', 'Disetujui')
        ->countAllResults();

    $totalDitolak = $evaluasiModel
        ->where('id_guru', $idGuru)
        ->where('status', 'Ditolak')
        ->countAllResults();

    // Hitung jumlah evaluasi yang sudah dinilai
   // Hitung jumlah evaluasi yang sudah dinilai (rpp dan dokumentasi dan absensi tidak kosong/null)
$sudahDinilai = $evaluasiModel
    ->where('id_guru', $idGuru)
    ->where('status', 'disetujui')
    ->where('rpp IS NOT NULL')
    ->where('foto_kegiatan IS NOT NULL')
    ->where('absensi_bulanan IS NOT NULL')
    ->countAllResults();

    $periodeModel = new Periode();
    $dataperiode = $periodeModel
    ->select('periode.nama_periode as periode, periode.tahun_ajaran as tahun_ajaran, evaluasi_kinerja.nilai as total_nilai')
    ->join('evaluasi_kinerja', 'evaluasi_kinerja.periode = periode.id AND evaluasi_kinerja.id_guru = ' . (int)$idGuru, 'left')
    ->where('evaluasi_kinerja.nilai IS NOT NULL')
    ->orderBy('periode.id', 'ASC')
    ->findAll();



    // var_dump($dataperiode);


    return view('dashboard/guru', [
        'totalDisetujui' => $totalDisetujui,
        'totalDitolak'   => $totalDitolak,
        'evaluasi'       => $evaluasi,
        'sudahDinilai'   => $sudahDinilai,
        'dataperiode'    => $dataperiode,
    ]);
}





}
