<?php

namespace App\Controllers;

use App\Models\GuruModel;
use App\Models\EvaluasiModel;
use Dompdf\Dompdf;

class GuruController extends BaseController
{
    protected $guruModel;
    protected $EvaluasiModel;

    public function __construct()
    {
        $this->guruModel = new GuruModel();
        $this->EvaluasiModel = new EvaluasiModel();
    }

    public function index()
    {
        $data['guru'] = $this->guruModel->findAll();
        return view('guru/input', $data);
    }

    public function create()
    {
        $login = session()->get('login');
        if ($login['role'] !== 'admin') {
            return redirect()->to('/dashboard');
        }

        return view('guru/create');
    }

    public function store()
    {
        $login = session()->get('login');
        if ($login['role'] !== 'admin') {
            return redirect()->to('/dashboard');
        }

        $this->guruModel->save($this->request->getPost());
        return redirect()->to('/guru')->with('success', 'Data berhasil ditambahkan');
    }

    public function edit($id)
    {
        $login = session()->get('login');
        if (!$login || $login['role'] !== 'admin') {
            return redirect()->to('/dashboard');
        }

        $data['guru'] = $this->guruModel->find($id);
        return view('guru/edit', $data);
    }

    public function update($id)
    {
        $login = session()->get('login');
        if ($login['role'] !== 'admin') {
            return redirect()->to('/dashboard');
        }

        $this->guruModel->update($id, $this->request->getPost());
        return redirect()->to('/guru')->with('success', 'Data berhasil diperbarui');
    }

    public function delete($id)
    {
        $login = session()->get('login');
        if ($login['role'] !== 'admin') {
            return redirect()->to('/dashboard');
        }

        $this->guruModel->delete($id);
        return redirect()->to('/guru')->with('success', 'Data berhasil dihapus');
    }

    public function evaluasi()
    {
        $session = session();
        $login = $session->get('login');

        if (!$login || $login['role'] !== 'guru') {
            return redirect()->to('/login')->with('error', 'Akses ditolak.');
        }

        $idUser = $login['id'];

        $evaluasiModel = new \App\Models\EvaluasiModel();

        $data['evaluasi'] = $evaluasiModel
            ->select('evaluasi_kinerja.*, guru.nama_guru, periode.nama_periode AS periode, 
                      periode.tahun_ajaran AS tahun_ajaran')
            ->join('guru', 'guru.id = evaluasi_kinerja.id_guru')
            ->join('periode', 'periode.id = evaluasi_kinerja.periode', 'left')
            ->join('users', 'users.id_guru = evaluasi_kinerja.id_guru')
            ->where('users.id', $idUser)
            ->findAll();

        return view('guru/evaluasi', $data);
    }

    public function cetakPdf()
    {
        $data['guru'] = $this->guruModel->findAll();
        $html = view('guru/cetak_pdf', $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
        $dompdf->stream('data_guru.pdf', ['Attachment' => false]);
    }
}
