<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\Periode;
class PeriodeController extends BaseController
{
    protected $periodeModel;

    public function __construct()
    {
        $this->periodeModel = new Periode();
    }

    public function index()
    {
        $data['title'] = 'Manajemen Periode';
        $data['periode'] = $this->periodeModel->findAll();

        return view('periode/index', $data);
    }

    public function create()
    {
        $data['title'] = 'Tambah Periode';
        return view('periode/create', $data);
    }

    public function delete($id)
    {
        $model = new \App\Models\Periode();
        $model->delete($id);

        return redirect()->to('/periode')->with('success', 'Data berhasil dihapus.');
    } 

    public function store()
    {
        $data = [
            'nama_periode' => $this->request->getPost('nama_periode'),
            'tahun_ajaran' => $this->request->getPost('tahun_ajaran'),
            'tanggal_mulai' => $this->request->getPost('tanggal_mulai'),
            'tanggal_selesai' => $this->request->getPost('tanggal_selesai'),
        ];

        if ($this->periodeModel->insert($data)) {
            session()->setFlashdata('success', 'Periode berhasil ditambahkan.');
        } else {
            session()->setFlashdata('error', 'Gagal menambahkan periode.');
        }

        return redirect()->to(base_url('periode'));
    }
}
