<?php

namespace App\Models;
use CodeIgniter\Model;

class GuruModel extends Model
{
    protected $table = 'guru';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'kode_guru', 'nama_guru', 'nip', 'tempat_lahir', 'tanggal_lahir',
        'jenis_kelamin', 'status', 'agama', 'jabatan', 'pendidikan'
    ];

    public function getTotalGuru()
    {
        return $this->countAll();
    }
    public function getByUserId($userId)
    {
        return $this->where('id_user', $userId)->first();
    }

}

