<!DOCTYPE html>
<html lang="en">

<head>
  <?= $this->include('layout/head') ?>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Dashboard - EduControl</title>
  <meta content="" name="description">
  <meta content="" name="keywords">
  <!-- Favicons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


  <!-- =======================================================
  * Template Name: NiceAdmin
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Updated: Apr 20 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body>
  <?= $this->include('layout/sidebar') ?>
  <!-- ======= Sidebar ======= -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Dashboard</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Home</a></li>
          <li class="breadcrumb-item active">Dashboard</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
    <div class="container mt-4">
        <div class="row">
            <!-- Card Statistik -->
            <div class="col-md-4">
                <div class="card text-white bg-success mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Guru</h5>
                        <p class="card-text display-4">50</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-white bg-warning mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Guru Aktif</h5>
                        <p class="card-text display-4">45</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-white bg-danger mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Guru Tidak Aktif</h5>
                        <p class="card-text display-4">5</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Grafik Kinerja Guru -->
        <div class="card mt-3">
            <div class="card-body">
                <h5 class="card-title">Grafik Kinerja Guru</h5>
                <canvas id="performanceChart"></canvas>
            </div>
        </div>
    </div>
    <footer id="footer" class="footer text-center mt-4 p-3 bg-light">
        &copy; 2025 Manajemen Kinerja Guru. All Rights Reserved.
    </footer>

    <script>
        var ctx = document.getElementById('performanceChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Guru A', 'Guru B', 'Guru C', 'Guru D', 'Guru E'],
                datasets: [{
                    label: 'Skor Kinerja',
                    data: [85, 90, 78, 88, 92],
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100
                    }
                }
            }
        });
    </script>  
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>