<!DOCTYPE html>
<html lang="en">
<head>
    <title>Rekapan Evaluasi Guru</title>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>
<body>
<?= $this->include('layout/sidebar') ?>
<main id="main" class="main">
    <div class="container-fluid p-4">
        <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
            <div class="container-fluid d-flex justify-content-between align-items-center">
                <h4 class="m-0 text-primary">Laporan Kinerja Guru</h4>
                <div>
                    <a href="<?= base_url('evaluasi/create') ?>" class="btn btn-success btn-sm me-2">
                        <i class="fa fa-plus"></i> Tambah
                    </a>
                    <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                        <i class="fa fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </div>
        </nav>

        <div class="card shadow">
            <div class="card-header text-white" style="background-color: #5c8978;">
                <strong>Data Laporan Kinerja</strong>
            </div>
            <div class="card-body">
                <div class="mb-3 d-flex justify-content-between align-items-center">                   
                    <input type="text" id="searchInput" class="form-control w-25" placeholder="Cari...">
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped text-center" id="evaluasiTable">
                        <thead class="bg-light">
                        <tr>
                            <th>No</th>
                            <th>Periode</th>
                            <th>Status</th>
                            <th>Tanggal Pengajuan</th>                                               
                            <th>Aksi</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($evaluasi)): ?>
                            <?php $no = 1; foreach ($evaluasi as $e): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($e['periode']) . ' ' . esc($e['tahun_ajaran']) ?></td>
                                     <td class="status-cell">
                                        <?php if ($e['status'] === 'Diajukan'): ?>
                                            <span class="badge bg-warning text-dark">Diajukan</span>
                                        <?php elseif ($e['status'] === 'Disetujui'): ?>
                                            <span class="badge bg-primary">Disetujui</span>
                                        <?php elseif ($e['status'] === 'Dinilai'): ?>
                                            <span class="badge bg-success">Dinilai</span>
                                        <?php elseif ($e['status'] === 'Ditolak'): ?>
                                            <span class="badge bg-danger">Ditolak</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?= esc($e['status']) ?></span>
                                        <?php endif ?>
                                    </td>
                                    <td><?= date('d-m-Y H:i:s', strtotime($e['created_at'])) ?></td>                                                  
                                    <td>
                                        <!-- Tombol Detail -->
                                        <button class="btn btn-info btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#detailModal<?= $e['id'] ?>">
                                            <i ></i> Lihat Detail
                                        </button>
                                        <?php if ($e['status'] === 'Diajukan' || $e['status'] === 'Ditolak'): ?>
                                            <a href="<?= base_url('evaluasi/edit/' . $e['id']) ?>" class="btn btn-sm btn-primary mb-1">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <a href="<?= base_url('evaluasi/delete/' . $e['id']) ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Yakin ingin menghapus data ini?');">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>

                            <!-- Modal Detail -->
                            <div class="modal fade" id="detailModal<?= $e['id'] ?>" tabindex="-1" aria-labelledby="detailLabel<?= $e['id'] ?>" aria-hidden="true">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header text-white" style="background-color: #5c8978;">
                                            <h5 class="modal-title" id="detailLabel<?= $e['id'] ?>">Detail Laporan</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>

                                        <div class="modal-body text-start">
                                            <!-- Informasi -->
                                            <div class="mb-3">
                                                <label class="form-label fw-bold">Periode</label>
                                                <input type="text" class="form-control" readonly value="<?= esc($e['periode']) ?> - <?= esc($e['tahun_ajaran']) ?>">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label fw-bold">Tanggal Pengajuan</label>
                                                <input type="text" class="form-control" readonly value="<?= date('d-m-Y H:i:s', strtotime($e['created_at'])) ?>">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label fw-bold">Status</label>
                                                <input type="text" class="form-control" readonly value="<?= esc($e['status']) ?>">
                                            </div>

                                            <?php if ($e['status'] === 'Ditolak' && !empty($e['alasan_penolakan'])): ?>
                                                <div class="mb-3">
                                                    <label class="form-label text-danger fw-bold">Alasan Penolakan</label>
                                                    <textarea class="form-control text-danger" readonly rows="2"><?= esc($e['alasan_penolakan']) ?></textarea>
                                                </div>
                                            <?php endif ?>

                                            <!-- Dokumen -->
                                            <div class="mt-4">
                                                <label class="form-label fw-bold">Berkas Pendukung</label>
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label small mb-1">RPP</label><br>
                                                       <?php if (!empty($e['rpp'])): ?>
                                                            <a href="<?= base_url('uploads/rpp/' . $e['rpp']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat</a>
                                                        <?php elseif (!empty($e['rpp_terakhir'])): ?>
                                                            <a href="<?= base_url('uploads/rpp/' . $e['rpp_terakhir']) ?>" target="_blank" class="btn btn-outline-warning btn-sm w-100">Lihat RPP Terakhir</a>
                                                        <?php else: ?>
                                                            <span class="text-muted">Tidak tersedia</span>
                                                        <?php endif ?>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label small mb-1">Kehadiran</label><br>
                                                        <?php if (!empty($e['dokumen_absensi'])): ?>
                                                            <a href="<?= base_url('uploads/absensi/' . $e['dokumen_absensi']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat</a>
                                                        <?php else: ?>
                                                            <span class="text-muted">Tidak tersedia</span>
                                                        <?php endif ?>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label small mb-1">Foto Kegiatan</label><br>
                                                        <?php if (!empty($e['foto_kegiatan'])): ?>
                                                            <a href="<?= base_url('uploads/foto_kegiatan/' . $e['foto_kegiatan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat</a>
                                                        <?php else: ?>
                                                            <span class="text-muted">Tidak tersedia</span>
                                                        <?php endif ?>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label small mb-1">Dokumen Kedisiplinan</label><br>
                                                        <?php if (!empty($e['dokumen_kedisiplinan'])): ?>
                                                            <a href="<?= base_url('uploads/kedisiplinan/' . $e['dokumen_kedisiplinan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat</a>
                                                        <?php else: ?>
                                                            <span class="text-muted">Tidak tersedia</span>
                                                        <?php endif ?>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label small mb-1">Tema Bulanan</label><br>
                                                        <?php if (!empty($e['tema_bulanan'])): ?>
                                                            <a href="<?= base_url('uploads/tema_bulanan/' . $e['tema_bulanan']) ?>" target="_blank" class="btn btn-outline-primary btn-sm w-100">Lihat</a>
                                                        <?php else: ?>
                                                            <span class="text-muted">Tidak tersedia</span>
                                                        <?php endif ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="modal-footer justify-content-end mt-4">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach ?>
                        <?php else: ?>
                            <tr><td colspan="7">Belum ada data evaluasi.</td></tr>
                        <?php endif ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const searchInput = document.getElementById('searchInput');
        const statusFilter = document.getElementById('statusFilter');
        const table = document.getElementById('evaluasiTable');
        const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

        function filterTable() {
            const searchValue = searchInput.value.toLowerCase();
            const selectedStatus = statusFilter.value.toLowerCase();

            for (let i = 0; i < rows.length; i++) {
                const rowText = rows[i].textContent.toLowerCase();
                const statusCell = rows[i].querySelector('.status-cell');
                const statusText = statusCell ? statusCell.textContent.toLowerCase() : '';
                const matchesSearch = rowText.includes(searchValue);
                const matchesStatus = selectedStatus === '' || statusText.includes(selectedStatus);
                rows[i].style.display = (matchesSearch && matchesStatus) ? '' : 'none';
            }
        }
        searchInput.addEventListener('keyup', filterTable);
        statusFilter.addEventListener('change', filterTable);
    });
</script>

</body>
</html>
