<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <!-- Main Content -->
        <div class="container-fluid p-4">

            <!-- Topbar -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Manajemen Kelas</h4>
                    <div>
                        <a href="<?= base_url('kelas/create') ?>" class="btn btn-success btn-sm me-2">
                            <i class="fa fa-plus"></i> Tambah Kelas
                        </a>
                        <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </nav>

            <!-- Flash Message -->
            <?php if (session()->getFlashdata('success')) : ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <!-- Card Data Kelas -->
            <div class="card shadow">
                <div class="card-header" style="background-color: #5c8978;">
                    <strong>Data Kelas</strong>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center">
                            <thead class="bg-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama Kelas</th>
                                    <th>Jumlah Murid</th>
                                    <th>Tahun Ajaran</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; foreach ($kelas as $k): ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($k['nama_kelas']) ?></td>
                                    <td><?= esc($k['jumlah_murid']) ?></td>
                                    <td><?= esc($k['tahun_ajaran']) ?></td>
                                    <td>
                                        <a href="<?= base_url('kelas/edit/' . $k['id']) ?>" class="btn btn-warning btn-sm me-1">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <a href="<?= base_url('kelas/delete/' . $k['id']) ?>" onclick="return confirm('Yakin ingin menghapus?')" class="btn btn-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>
</body>

</html>
