<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SIKINERJA AL-HUSNA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #e0f2f1, #ffffff);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            background-color: white;
        }
        .btn-custom {
            background-color: #5c8978;
            color: white;
        }
        .btn-custom:hover {
            background-color: #4a7264;
        }
        .logo {
            width: 160px;
            height: auto;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-5">
                <div class="login-card text-center">
                    <!-- Logo -->
                    <img src="<?= base_url('assets/img/logo.jpg') ?>" alt="SIM-EKG AL-HUSNA" class="logo mx-auto d-block">

                   <h4 class="mb-4 fw-bold" style="color:rgb(31, 119, 85);">SIKINERJA AL-HUSNA</h4>


                    <?php if (session()->getFlashdata('error')): ?>
                        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
                    <?php endif; ?>

                    <form method="post" action="<?= base_url('/auth/login') ?>">
                        <div class="mb-3 text-start">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" name="username" required>
                        </div>
                        <div class="mb-3 text-start">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-custom w-100">Login</button>
                    </form>
                </div>
                <p class="text-center mt-3 text-muted small">© <?= date('Y') ?> Yayasan Al-Husna</p>
            </div>
        </div>
    </div>
</body>
</html>
