<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
    <?= $this->include('layout/sidebar') ?>
    <main id="main" class="main">
        <div class="pagetitle">
            <div class="container mt-4">
                <!-- Form Edit Profil -->
                <div class="card shadow">
                    <div class="card-header text-white" style="background-color: #5c8978;">
                        <strong>Edit Profil</strong>
                    </div>
                    <div class="card-body">
                        <form action="<?= base_url('profile/update') ?>" method="post" enctype="multipart/form-data">
                            <?= csrf_field() ?>
                            <div class="row">
                                <!-- Kolom Kiri -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nama" class="form-label">Nama Lengkap</label>
                                        <input type="text" name="nama" class="form-control" value="<?= esc($user['nama'] ?? '') ?>" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="no_hp" class="form-label">No HP</label>
                                        <input type="text" name="no_hp" class="form-control" value="<?= esc($user['no_hp'] ?? '') ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" name="email" class="form-control" value="<?= esc($user['email'] ?? '') ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="agama" class="form-label">Agama</label>
                                        <input type="text" name="agama" class="form-control" value="<?= esc($user['agama'] ?? '') ?>">
                                    </div>

                                      <div class="mb-3">
                                        <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                                        <input type="text" name="tempat_lahir" class="form-control" value="<?= esc($user['tempat_lahir'] ?? '') ?>">
                                    </div>
                                </div>

                                <!-- Kolom Kanan -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                                        <input type="date" name="tanggal_lahir" class="form-control" value="<?= esc($user['tanggal_lahir'] ?? '') ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                                        <select name="jenis_kelamin" class="form-control">
                                            <option value="Laki-laki" <?= ($user['jenis_kelamin'] ?? '') === 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                                            <option value="Perempuan" <?= ($user['jenis_kelamin'] ?? '') === 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="alamat" class="form-label">Alamat</label>
                                        <textarea name="alamat" class="form-control" rows="3"><?= esc($user['alamat'] ?? '') ?></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="photo" class="form-label">Foto Profil</label>
                                        <input type="file" name="photo" class="form-control" accept="image/*">
                                    </div>
                                </div>
                            </div>

                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-success  btn-sm me-2">
                                <i class="fa fa-save"></i> Simpan
                            </button>
                            <a href="<?= base_url('profile') ?>" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left"></i> Batal
                            </a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
