<?= $this->include('layout/head') ?>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
  <div class="container-fluid p-4">

    <!-- Judul Halaman -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
      <div class="container-fluid d-flex justify-content-between align-items-center">
        <h4 class="m-0 text-primary">Upload RPP per Semester</h4>
        <a href="<?= base_url('evaluasi/create') ?>" class="btn btn-secondary btn-sm">
          <i class="fas fa-arrow-left"></i> Kembali
        </a>
      </div>
    </nav>

    <!-- Notifikasi -->
    <?php if (session()->getFlashdata('success')): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php elseif (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php endif; ?>

    <!-- Form Upload -->
    <form action="<?= base_url('rpp/upload') ?>" method="post" enctype="multipart/form-data">
      <?= csrf_field() ?>

      <div class="card shadow">
        <div class="card-header text-white" style="background-color: #5c8978;">
          <strong>Form Upload RPP</strong>
        </div>
        <div class="card-body">

          <div class="mb-3">
            <label for="rpp" class="form-label">Pilih File RPP (PDF/DOC)</label>
            <input type="file" name="rpp" id="rpp" class="form-control" accept=".pdf,.doc,.docx" required>
          </div>

          <div class="text-end mt-4">
            <button type="submit" class="btn btn-success btn-sm me-2">
              <i class="fas fa-upload"></i> Upload
            </button>
            <a href="<?= base_url('evaluasi/create') ?>" class="btn btn-secondary btn-sm">
              <i class="fas fa-times"></i> Batal
            </a>
          </div>

        </div>
      </div>
    </form>

  </div>
</main>
