<!DOCTYPE html>
<html lang="en">

<head>
    <?= $this->include('layout/head') ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>

<body>
<?= $this->include('layout/sidebar') ?>

<main id="main" class="main">
    <div class="pagetitle">
        <!-- Main Content -->
        <div class="container-fluid p-4">
            <!-- Topbar -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
                <div class="container-fluid d-flex justify-content-between align-items-center">
                    <h4 class="m-0 text-primary">Manajemen Akun</h4>
                    <div>
                    <?php if (session()->get('login')['role'] === 'admin'): ?>
                        <a href="<?= base_url('users/create') ?>" class="btn btn-success btn-sm me-2">
                            <i class="fa fa-plus"></i> Tambah
                        </a>
                    <?php endif; ?>
                        <a href="<?= base_url('dashboard') ?>" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
            </nav>
             <div class="card shadow">
                <div class="card-header" style="background-color: #5c8978;" >
                    <strong>Data Akun Aktif</strong>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped text-center">
                            <thead class="bg-light">
                                <tr>
                                    <th>No</th>
                                    <th>Nama</th>
                                    <th>Username</th>
                                    <th>Role</th>
                                    <th>Aksi</th>
                                </tr>
                        <?php $no = 1; foreach ($users as $u): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= $u['nama'] ?></td>
                                <td><?= $u['username'] ?></td>
                                <td><?= $u['role'] ?></td>
                                <td>
                            <a href="/users/edit/<?= $u['id'] ?>" class="btn btn-warning btn-sm me-1" title="Edit">
                                <i class="fa fa-edit"></i>
                            </a>
                            <a href="/users/delete/<?= $u['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Hapus akun ini?')" title="Hapus">
                                <i class="fa fa-trash"></i>
                            </a>
                        </td>

                         </tr>
                    <?php endforeach; ?>
        </tbody>
</table>
